<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

SpAddonsConfig::addonConfig([
	'type'       => 'general',
	'addon_name' => 'progress_bar',
	'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR'),
	'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_DESC'),
	'category'   => 'Content',
	'icon'       => '<svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path opacity=".5" fill-rule="evenodd" clip-rule="evenodd" d="M27.938 4H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zM4.062 3a2.062 2.062 0 100 4.123h23.876a2.062 2.062 0 100-4.123H4.062z" fill="currentColor"/><rect x="2" y="3" width="7" height="4.123" rx="2.062" fill="currentColor"/><path opacity=".5" fill-rule="evenodd" clip-rule="evenodd" d="M27.938 25.877H4.062a1.062 1.062 0 000 2.123h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 000 4.123h23.876a2.062 2.062 0 100-4.123H4.062z" fill="currentColor"/><rect x="2" y="24.877" width="14" height="4.123" rx="2.062" fill="currentColor"/><path opacity=".5" fill-rule="evenodd" clip-rule="evenodd" d="M27.938 15.34H4.062a1.062 1.062 0 100 2.122h23.876a1.062 1.062 0 100-2.123zm-23.876-1a2.062 2.062 0 100 4.122h23.876a2.062 2.062 0 100-4.123H4.062z" fill="currentColor"/><rect x="2" y="14.339" width="20" height="4.123" rx="2.062" fill="currentColor"/></svg>',
	'settings' => [
		'progress_bar' => [
			'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR'),
			'fields' => [
				'type' => [
					'type'   => 'select',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_TYPE'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_TYPE_DESC'),
					'values' => [
						'sppb-progress-bar-default'=>Text::_('Default'),
						'flex'=>Text::_('Flex'),
						'sppb-progress-bar-primary major_color_bckg-100' => Text::_('COM_SPPAGEBUILDER_GLOBAL_PRIMARY'),
						'sppb-progress-bar-success bg-success' => Text::_('COM_SPPAGEBUILDER_GLOBAL_SUCCESS'),
						'sppb-progress-bar-info bg-info' => Text::_('COM_SPPAGEBUILDER_GLOBAL_INFO'),
						'sppb-progress-bar-warning bg-warning' => Text::_('COM_SPPAGEBUILDER_GLOBAL_WARNING'),
						'sppb-progress-bar-danger bg-danger' => Text::_('COM_SPPAGEBUILDER_GLOBAL_DANGER'),
						'custom' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CUSTOM'),
					],
					'std' => 'sppb-progress-bar-default',
				],

				'stripped' => [
					'type'   => 'radio',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_STRIPPED'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_STRIPPED_DESC'),
					'values' => [
						''                          => Text::_('JNO'),
						'sppb-progress-bar-striped' => Text::_('JYES'),
					],
				],
				
				'active' => [
					'type'   => 'radio',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_ACTIVE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_ACTIVE_DESC'),
					'values' => [
						'' => Text::_('JNO'),
						'active' => Text::_('JYES'),
					],
				],

				'text_separator' => [
					'type'  => 'separator',
				],

				'text' => [
					'type'  => 'text',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_LABEL'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_TEXT_DESC'),
					'inline' => true,
				],

				'label_typography' => [
					'type' => 'typography',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'fallbacks'   => [
						'font' => 'text_fontfamily',
						'size' => 'text_fontsize',
						'line_height' => 'text_lineheight',
						'weight' => 'text_fontweight',
					],
				],

				'text_color' => [
					'type'   => 'color',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
					'depends'=> [['text', '!=', '']],
				],

				'bar_separator' => [
					'type'  => 'separator',
				],

				'custom_height' => [
					'type'  => 'slider',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_HEIGHT'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_HEIGHT_DESC'),
					'std'   => 24,
					'min'   => 1,
					'max'   => 100,
					'info'	=> 'px',
				],

				'bar_background' => [
					'type'   => 'color',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_CUSTOM_BACKGROUND_COLOR'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_CUSTOM_BACKGROUND_COLOR_DESC'),
					'std' => '#cccccc',
					//'depends'=> [['type', '=', 'custom']],
				],
				
				'custom_color' => [
					'type'  => 'color',
					'std'   => 'rgba(51, 102, 255, 0.15)',
					'title'	=> Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_CUSTOM_COLOR'),
					'desc'	=> Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_CUSTOM_COLOR_DESC'),
					'std' 	=> '#f14833',
					//'depends'=> [['type', '=', 'custom']],
				],

				'progress_separator' => [
					'type'  => 'separator',
				],

				'progress' => [
					'type'  => 'slider',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_PROGRESS'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_PROGRESS_DESC'),
					'std'   => 60,
					'min'   => 1,
					'max'   => 100,
					'info'	=> '%',
				],
				
				'animation_duration' => [
					'type'  => 'slider',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_ANIMATION_DURATION'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_ANIMATION_DURATION_DESC'),
					'std'   => 2,
					'min'	=> 1,
					'max'	=> 10,
					'info'	=> 'seconds',
				],
				
				'animation_delay' => [
					'type'  => 'slider',
					'title'	=> Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_ANIMATION_DELAY'),
					'desc'	=> Text::_('COM_SPPAGEBUILDER_ADDON_PROGRESS_BAR_ANIMATION_DELAY_DESC'),
					'std'   => 0,
					'min'	=> 0,
					'max'	=> 10,
					'info'	=> 'seconds',
				],
				
				'animation_delay_separator' => [
					'type'  => 'separator',
				],
			],
		],
	],
]);