<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

//Include Pixeden Icons
require_once dirname(dirname( __DIR__ )) . '/fields/pixeden-icons.php';

SpAddonsConfig::addonConfig(
	array(
		'type'=>'content',
		'addon_name'=>'pricing',
		'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_PRICING'),
		'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_PRICING_DESC'),
		'category'=>'Content',
		'icon'=>'<svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path opacity=".5" fill-rule="evenodd" clip-rule="evenodd" d="M.15 9A2.85 2.85 0 013 6.15h5v1.7H3A1.15 1.15 0 001.85 9v14c0 .635.515 1.15 1.15 1.15h5v1.7H3A2.85 2.85 0 01.15 23V9zM31.85 23A2.85 2.85 0 0129 25.85h-5v-1.7h5A1.15 1.15 0 0030.15 23V9A1.15 1.15 0 0029 7.85h-5v-1.7h5A2.85 2.85 0 0131.85 9v14z" fill="currentColor"/><path fill-rule="evenodd" clip-rule="evenodd" d="M23 1.707H9c-.22 0-.4.19-.4.426v27.734c0 .235.18.426.4.426h14c.22 0 .4-.19.4-.426V2.133c0-.235-.18-.426-.4-.426zM9 0C7.895 0 7 .955 7 2.133v27.734C7 31.045 7.895 32 9 32h14c1.105 0 2-.955 2-2.133V2.133C25 .955 24.105 0 23 0H9z" fill="currentColor"/><path d="M18.24 11.04c0 .587-.187 1.063-.56 1.43-.373.36-.86.577-1.46.65V14h-.67v-.87c-.56-.04-1.04-.197-1.44-.47a2.264 2.264 0 01-.86-1.11l1.19-.69c.213.533.583.837 1.11.91v-1.73h-.01l-.02-.01a8.986 8.986 0 01-.57-.23 4.433 4.433 0 01-.52-.29 2.134 2.134 0 01-.46-.39 2.306 2.306 0 01-.29-.53 1.979 1.979 0 01-.12-.7c0-.587.19-1.057.57-1.41.387-.353.86-.557 1.42-.61V5h.67v.89c.907.107 1.547.577 1.92 1.41l-1.16.68c-.16-.4-.413-.643-.76-.73v1.67c.62.247 1.037.443 1.25.59.513.367.77.877.77 1.53zM14.93 7.9c0 .147.047.277.14.39.093.107.253.217.48.33v-1.4c-.2.04-.353.12-.46.24a.639.639 0 00-.16.44zm1.29 3.85c.427-.093.64-.327.64-.7a.59.59 0 00-.16-.42c-.1-.113-.26-.22-.48-.32v1.44z" fill="currentColor"/><path opacity=".5" fill-rule="evenodd" clip-rule="evenodd" d="M21 16.5a.5.5 0 01-.5.5h-9a.5.5 0 010-1h9a.5.5 0 01.5.5zM19 18.5a.5.5 0 01-.5.5h-5a.5.5 0 010-1h5a.5.5 0 01.5.5z" fill="currentColor"/><rect x="11" y="24" width="10" height="3" rx="1.5" fill="currentColor"/></svg>',
		
		'attr'=>array(
			'general' => array(

				'admin_label'=>array(
					'type'=>'text',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
					'std'=> ''
				),
				
				'header_separator'=>array(
					'type'=>'separator',
					'title'=>Text::_('Header'),
				),

				'title'=>array(
					'type'=>'text',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_PRICING_TITLE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_PRICING_TITLE_DESC'),
					'std'=>'POPULAR',
				),
				
				'title_typography' => [
					'type'     => 'typography',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'fallbacks'   => [
						'font'           => 'title_font_family',
						'size'           => 'title_fontsize',
						'line_height'    => 'title_lineheight',
						'letter_spacing' => 'title_letterspace',
						'uppercase'      => 'title_font_style.uppercase',
						'italic'         => 'title_font_style.italic',
						'underline'      => 'title_font_style.underline',
						'weight'         => 'title_font_style.weight',
					],
				],

				'price'=>array(
					'type'=>'text',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_PRICING_PRICE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_PRICING_PRICE_DESC'),
					'std'=>'29',
				),
				
				'price_typography' => [
					'type'     => 'typography',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'fallbacks'   => [
						'font'   => 'price_font_family',
						'size'   => 'price_font_size',
						'weight' => 'price_font_weight',
					],
				],
				
				'currency'=>array(
					'type'=>'text', 
					'title'=>Text::_('FLEX_ADDON_PRICING_CURRENCY'),
					'desc'=>Text::_('FLEX_ADDON_PRICING_CURRENCY_DESC'),
					'std'=>'$',
				),

				'duration'=>array(
					'type'=>'text',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_PRICING_DURATION'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_PRICING_DURATION_DESC'),
					'std'=>' /Month',
				),
				
				'header_color_separator'=>array(
					'type'=>'separator',
					'title'=>Text::_(''),
				),
				
				'header_color'=>array(
					'type'=>'color', 
					'title'=>Text::_('FLEX_ADDON_PRICING_HEADER_COLOR'),
					'desc'=>Text::_('FLEX_ADDON_PRICING_HEADER_COLOR_DESC'),
					),
				
				// Is Featured
				'featured'=>array(
					'type'=>'select',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_PRICING_FEATURED'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_PRICING_FEATURED_DESC'),
					'values'=>array(
						''=>Text::_('JNO'),
						'sppb-pricing-featured'=>Text::_('JYES'),
					),
					'std'=>'',
				),
				
				'pricing_content_separator'=>array(
					'type'=>'separator',
					'title'=>Text::_(''),
				),

				'pricing_content'=>array(
					'type'=>'textarea',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_PRICING_FEATURES'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_PRICING_FEATURES_DESC'),
					'std'=>'<strong>512MB</strong> Memory
3 Users
5 Websites
<a href="#_" data-toggle="tooltip" data-placement="top" title="Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.">7 Domains</a>
Unlimited Bandwidth
24/7 Support',
				),
				
				'pricing_content_typography' => [
					'type'     => 'typography',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'fallbacks'   => [
						'font'   => 'pricing_content_font_family',
						'size'   => 'pricing_content_font_size',
						'weight' => 'pricing_content_font_weight',
					],
				],

				'background'=>array(
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND_COLOR_DESC'),
				),

				'color'=>array(
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR_DESC'),
				),
				
				'button_separator'=>array(
					'type'=>'separator',
					'title'=>Text::_(''),
				),

				//Button
				'button_text'=>array(
					'type'=>'text',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_TEXT'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_TEXT_DESC'),
					'std'=>'BUY NOW',
				),
				
				'button_url'=>array(
					'type'=>'link',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_URL'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_URL_DESC'),
					//'placeholder'=>'http://',
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),
				
				'button_typography' => [
					'type' => 'typography',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'fallbacks' => [
						'font' => 'button_font_family',
						'letter_spacing' => 'button_letterspace',
						'weight' => 'button_fontstyle.weight',
						'italic' => 'button_fontstyle.italic',
						'underline' => 'button_fontstyle.underline',
						'uppercase' => 'button_fontstyle.uppercase',
					],
				],
		
				'button_type'=>array(
					'type'=>'select',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_STYLE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_STYLE_DESC'),
					'values'=>array(
						'default'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_DEFAULT'),
						'flex'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_FLEX'),
						'dark'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_DARK'),
						'light'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_LIGHT'),
						'primary'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_PRIMARY'),
						'success'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_SUCCESS'),
						'info'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_INFO'),
						'warning'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_WARNING'),
						'danger'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_DANGER'),
						'link'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_LINK'),
						'custom'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_CUSTOM'),
					),
					'std'=>'default',
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),

				'button_appearance'=>array(
					'type'=>'select',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_DESC'),
					'values'=>array(
						''=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_FLAT'),
						'gradient'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_GRADIENT'),
						'outline'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_OUTLINE'),
						'3d'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_3D'),
					),
					'std'=>'flat',
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),

				'button_status'=>array(
					'type'=>'buttons',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_ENABLE_BACKGROUND_OPTIONS'),
					'std'=>'normal',
					'values'=>array(
						array(
							'label' => 'Normal',
							'value' => 'normal'
						),
						array(
							'label' => 'Hover',
							'value' => 'hover'
						),
					),
					'tabs' => true,
					'depends'=>array(
						array('button_text', '!=', ''),
						array('button_type', '=', 'custom'),
					)
				),
	
				'button_background_color'=>array(
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR_DESC'),
					'std' => '#CFBD65',
					'depends'=>array(
						array('button_appearance', '!=', 'gradient'),
						array('button_text', '!=', ''),
						array('button_type', '=', 'custom'),
						array('button_status', '=', 'normal'),
					),
				),
	
				'button_background_gradient'=>array(
					'type'=>'gradient',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND_GRADIENT'),
					'std'=> array(
						"color" => "#CFBD65",
						"color2" => "#B8A447",
						"deg" => "45",
						"type" => "linear"
					),
					'depends'=>array(
						array('button_text', '!=', ''),
						array('button_appearance', '=', 'gradient'),
						array('button_type', '=', 'custom'),
						array('button_status', '=', 'normal'),
					)
				),
	
				'button_color'=>array(
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR_DESC'),
					'std' => '#fff',
					'depends'=>array(
						array('button_text', '!=', ''),
						array('button_type', '=', 'custom'),
						array('button_status', '=', 'normal'),
					),
				),
	
				'button_background_color_hover'=>array(
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR_HOVER'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR_HOVER_DESC'),
					'std' => '#B8A447',
					'depends'=>array(
						array('button_appearance', '!=', 'gradient'),
						array('button_text', '!=', ''),
						array('button_type', '=', 'custom'),
						array('button_status', '=', 'hover'),
					),
				),
	
				'button_background_gradient_hover'=>array(
					'type'=>'gradient',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND_GRADIENT'),
					'std'=> array(
						"color" => "#B8A447",
						"color2" => "#CFBD65",
						"deg" => "45",
						"type" => "linear"
					),
					'depends'=>array(
						array('button_text', '!=', ''),
						array('button_appearance', '=', 'gradient'),
						array('button_type', '=', 'custom'),
						array('button_status', '=', 'hover'),
					)
				),
	
				'button_color_hover'=>array(
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR_HOVER'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR_HOVER_DESC'),
					'std' => '#fff',
					'depends'=>array(
						array('button_text', '!=', ''),
						array('button_type', '=', 'custom'),
						array('button_status', '=', 'hover'),
					),
				),

				'button_size'=>array(
					'type'=>'select',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_DESC'),
					'values'=>array(
						''=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_DEFAULT'),
						'lg'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_LARGE'),
						'xlg'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_XLARGE'),
						'sm'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_SMALL'),
						'xs'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_EXTRA_SAMLL'),
					),
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),
				'button_padding'=>array(
					'type'=>'padding',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_PADDING'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_PADDING_DESC'),
					'responsive'=>true,
					'depends'=> array(
						array('button_text', '!=', ''),
						array('button_type', '=', 'custom'),
					)
				),

				'button_shape'=>array(
					'type'=>'select',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_DESC'),
					'values'=>array(
						'rounded'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUNDED'),
						'square'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_SQUARE'),
						'round'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUND'),
					),
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),

				'button_block'=>array(
					'type'=>'radio',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BLOCK'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BLOCK_DESC'),
					'values'=>array(
						''=>Text::_('JNO'),
						'sppb-btn-block'=>Text::_('JYES'),
					),
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),
				
				'peicon_name'=>array( // Pixeden Icons
					'type'=>'select', 
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PE_ICON_NAME'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PE_ICON_NAME_DESC'),
					'depends'=> array(
						array('button_text', '!=', ''),
					),
					'values'=> $peicon_list,
					'std'=>'pe pe-7s-cart',
				),
				
				'button_icon'=>array(
					'type'=>'icon',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_FONTAWESOME_ICON_NAME'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_FONTAWESOME_ICON_NAME_DESC'),
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),

				'button_icon_position'=>array(
					'type'=>'radio',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_ICON_POSITION'),
					'values'=>array(
						'left'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
						'right'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
					),
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),
				
				'content_separator'=>array(
					'type'=>'separator',
					'title'=>Text::_(''),
				),
				
				'border_radius'=>array(
					'type'=>'slider',
					'title'=>Text::_('FLEX_ADDON_PRICING_BORDER_RADIUS'),
					'desc'=>Text::_('FLEX_ADDON_PRICING_BORDER_RADIUS_DESC'),
					//'std' => ['xl' => 5],
					'std' => 5,
					'max' => 100,
					//'responsive' => true,
				),

				'alignment'=>array(
					'type'=>'alignment',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_CONTENT_ALIGNMENT_DESC'),
					'std'=>'center',
				),

				'class'=>array(
					'type'=>'text',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					'std'=>''
				),

			),
		),
	)
);
