<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

//Include Pixeden Icons
require_once dirname(dirname( __DIR__ )) . '/fields/pixeden-icons.php';

SpAddonsConfig::addonConfig(
	array(
		'type'=>'content',
		'addon_name'=>'sp_prettyphoto_modal',
		'category'=>'Flex',
		'title'=>Text::_('FLEX_ADDON_PRETTYPHOTO_MODAL'),
		'desc'=>Text::_('FLEX_ADDON_PRETTYPHOTO_MODAL_DESC'),
		'attr'=>array(
			'general' => array(

				'admin_label'=>array(
					'type'=>'text',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
					'std'=> ''
				),
				
				'modal_selector' => [
					'type'   => 'buttons',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_DESC'),
					'values' => [
						['label' => Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_BUTTON'), 'value' => 'button'],
						['label' => Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE'), 'value' => 'image'],
						['label' => Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_TYPE_ICON'), 'value' => 'icon'],
					],
					'std' => 'button',
					'tabs' => true,
				],

				// Button
				'button_text'=>array(
					'type'=>'text',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_TEXT'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_TEXT_DESC'),
					'std'=>'Launch Modal',
					'depends'=>array(
						array('modal_selector', '=', 'button')
					),
				),

				'button_type'=>array(
					'type'=>'select',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_STYLE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_STYLE_DESC'),
					'values'=>array(
						'default'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_DEFAULT'),
						'flex'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_FLEX'),
						'dark'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_DARK'),
						'light'     => Text::_('COM_SPPAGEBUILDER_GLOBAL_LIGHT'),
						'primary'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_PRIMARY'),
						'secondary' => Text::_('COM_SPPAGEBUILDER_GLOBAL_SECONDARY'),
						'success'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_SUCCESS'),
						'info'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_INFO'),
						'warning'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_WARNING'),
						'danger'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_DANGER'),
						'link'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_LINK'),
						//'custom'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_CUSTOM'),
					),
					'std'=>'default',
					'depends'=>array(
						array('modal_selector', '=', 'button')
					),
				),
				
				'button_appearance' => [
					'type'   => 'buttons',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_DESC'),
					'values' => [
						['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_FLAT'), 'value' => ''],
						['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_OUTLINE'), 'value' => 'outline'],
						['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_3D'), 'value' => '3d'],
					],
					'std' => 'rounded',
					'tabs' => true,
					'depends' => [['modal_selector', '=', 'button']],
				],


				'button_background_color'=>array(
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR_DESC'),
					'std' => '#444444',
					'depends'=>array(
						array('modal_selector', '=', 'button'),
						array('button_type', '=', 'button_type')
					),
				),

				'button_color'=>array(
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR_DESC'),
					'std' => '#fff',
					'depends'=>array(
						array('modal_selector', '=', 'button'),
						array('button_type', '=', 'button_type')
					),
				),

				'button_background_color_hover'=>array(
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR_HOVER'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BACKGROUND_COLOR_HOVER_DESC'),
					'std' => '#222',
					'depends'=>array(
						array('modal_selector', '=', 'button'),
						array('button_type', '=', 'button_type')
					),
				),

				'button_color_hover'=>array(
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR_HOVER'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR_HOVER_DESC'),
					'std' => '#fff',
					'depends'=>array(
						array('modal_selector', '=', 'button'),
						array('button_type', '=', 'button_type')
					),
				),

				'button_size'=>array(
					'type'=>'select',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_DESC'),
					'values'=>array(
						''=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_DEFAULT'),
						'lg'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_LARGE'),
						'xlg'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_XLARGE'),
						'sm'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_SMALL'),
						'xs'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_EXTRA_SAMLL'),
					),
					'depends'=>array(
						array('modal_selector', '=', 'button')
					),
				),

				/*
				'button_shape'=>array(
					'type'=>'select',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_DESC'),
					'values'=>array(
						'rounded'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUNDED'),
						'square'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_SQUARE'),
						'round'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUND'),
					),
					'depends'=>array(
						array('modal_selector', '=', 'button')
					),
				),
				*/
				
				'button_shape' => [
					'type'   => 'buttons',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_DESC'),
					'values' => [
						['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUNDED'), 'value' => 'rounded'],
						['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_SQUARE'), 'value' => 'square'],
						['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUND'), 'value' => 'round'],
					],
					'std' => 'rounded',
					'tabs' => true,
					'depends' => [['modal_selector', '=', 'button']],
				],

				'button_block'=>array(
					'type' => 'radio',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BLOCK'),
					'desc' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BLOCK_DESC'),
					'values'=>array(
						''=>Text::_('JNO'),
						'sppb-btn-block'=>Text::_('JYES'),
					),
					'depends'=>array(
						array('modal_selector', '=', 'button')
					),
				),
				
				// Pixeden Icons
				'button_peicon'=>array(
					'type'=>'select', 
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_BUTTON_PIXEDEN_ICON'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_BUTTON_PIXEDEN_ICON_DESC'),
					'depends'=>array(
						array('modal_selector', '=', 'button')
					),
					'values'=> $peicon_list
				),

				'button_icon'=>array(
					'type'=>'icon',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_BUTTON_FONTAWESOME_ICON'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_BUTTON_FONTAWESOME_ICON_DESC'),
					'depends'=>array(
						array('modal_selector', '=', 'button')
					),
				),

				'button_icon_position' => [
					'type'   => 'buttons',
					'title'=>Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_ICON_POSITION'),
					'values' => [
						['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'), 'value' => 'left'],
						['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'), 'value' => 'right'],
					],
					'std' => 'left',
					'tabs' => true,
					'depends' => [['modal_selector', '=', 'button']],
				],
				

				// Selector Image
				'selector_image'=>array(
					'type'=>'media',
					//'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_IMAGE'),
					//'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_IMAGE_SELECT_DESC'),
					'std'=>'https://images.unsplash.com/photo-1561570541-aaba21a3ecf0?q=80&w=400&h=250&auto=format&fit=crop',
					'depends'=>array('modal_selector'=>'image')
				),
				
				// Pixeden Icons
				'peicon_name'=>array( // Pixeden Icons
					'type'=>'select', 
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_PIXEDEN_ICON'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_PIXEDEN_ICON_DESC'),
					'std'=> 'pe-7s-map-marker',
					'values'=> $peicon_list,
					'depends'=>array('modal_selector'=>'icon')
					
				),

				// Icon
				'selector_icon_name'=>array(
					'type'=>'icon',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_FONTAWESOME_ICON'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_FONTAWESOME_ICON_DESC'),
					'std'=> '',
					'depends'=>array('modal_selector'=>'icon')
				),

				'selector_icon_size'=>array(
					'type'=>'slider',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ICON_SIZE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ICON_SIZE_DESC'),
					//'placeholder'=>55,
					'std' => 55,
					'max' => 400,
					'depends'=>array('modal_selector'=>'icon')
				),

				'selector_icon_color'=>array(
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ICON_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ICON_COLOR_DESC'),
					'depends'=>array('modal_selector'=>'icon')
				),

				'selector_icon_background'=>array(
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ICON_BG_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ICON_BG_COLOR_DESC'),
					'depends'=>array('modal_selector'=>'icon')
				),

				'selector_icon_border_color'=>array(
					'type'=>'color',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ICON_BORDER_COLOR'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ICON_BORDER_COLOR_DESC'),
					'depends'=>array('modal_selector'=>'icon')
				),

				'selector_icon_border_width'=>array(
					'type'=>'number',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ICON_BORDER_WIDTH_SIZE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ICON_BORDER_WIDTH_SIZE_DESC'),
					'placeholder'=>1,
					'depends'=>array('modal_selector'=>'icon')
				),

				'selector_icon_border_radius'=>array(
					'type'=>'number',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ICON_BORDER_RADIUS'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ICON_BORDER_RADIUS_DESC'),
					'placeholder'=>5,
					'depends'=>array('modal_selector'=>'icon')
				),

				'selector_icon_padding'=>array(
					'type'=>'number',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ICON_PADDING'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ICON_PADDING_DESC'),
					'placeholder'=>20,
					'std'=>20,
					'depends'=>array('modal_selector'=>'icon')
				),


				//Admin Only
				'separator_1'=>array(
					'type'=>'separator',
					'title'=>Text::_(''),
				),
				
				'separator'=>array(
					'type'=>'separator',
					'title'=>Text::_('COM_SPPAGEBUILDER_MODAL_CONTENT'),
				),
				
				'separator_2'=>array(
					'type'=>'separator',
					'title'=>Text::_(''),
				),
				
				/*
				'modal_content_type'=>array(
					'type'=>'radio',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_CONTENT_TYPE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_CONTENT_TYPE_DESC'),
					'values'=>array(
						'text'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_CONTENT_TYPE_TEXT'),
						'image'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_CONTENT_TYPE_IMAGE'),
						'video'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_CONTENT_TYPE_VIDEO'),
					),
					'std'=>'text',
				),
				*/
				
				'modal_content_type' => [
					'type'   => 'buttons',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_CONTENT_TYPE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_CONTENT_TYPE_DESC'),
					'values' => [
						['label' => Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_CONTENT_TYPE_TEXT'), 'value' => 'text'],
						['label' => Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_CONTENT_TYPE_IMAGE'), 'value' => 'image'],
						['label' => Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_CONTENT_TYPE_VIDEO'), 'value' => 'video'],
					],
					'std' => 'text',
					'tabs' => true,
				],

				'modal_content_text'=>array(
					'type'=>'editor',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_TEXT'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_TEXT_DESC'),
					'std'=>'Collaboratively administrate empowered markets via plug-and-play networks. Efficiently unleash cross-media information without cross-media value. Quickly maximize timely deliverables for real-time schemas. Dramatically maintain clicks-and-mortar solutions without functional solutions. Completely synergize resource taxing relationships via premier niche markets. Professionally cultivate one-to-one customer service with robust ideas. Dynamically innovate resource-leveling customer service for state of the art customer service.<br /><br />Objectively innovate empowered manufactured products whereas parallel platforms. Holisticly predominate extensible testing procedures. Dramatically engage top-line web services vis-a-vis cutting-edge deliverables. Envisioned multimedia based expertise and cross-media growth strategies. Seamlessly visualize quality intellectual capital without superior collaboration and idea-sharing. Installed base portals after maintainable products. Phosfluorescently engage worldwide methodologies with web-enabled technology. Interactively coordinate proactive e-commerce via process-centric "outside the box" thinking. Completely pursue scalable customer service through sustainable potentialities.',
					'depends'=>array('modal_content_type'=>'text')
				),

				'modal_content_image'=>array(
					'type'=>'media',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_IMAGE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_IMAGE_DESC'),
					'std'=>'https://images.unsplash.com/photo-1614624532983-4ce03382d63d?q=80&w=800&h=460&auto=format&fit=crop',
					'depends'=>array('modal_content_type'=>'image')
					
				),

				'modal_content_video_url'=>array(
					'type'=>'text',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_VIDEO'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_VIDEO_DESC'),
					'std'=>'https://www.youtube.com/watch?v=BB-2nj8g78Y',
					'depends'=>array('modal_content_type'=>'video')
				),

				'modal_popup_width'=>array(
					'type'=>'number',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_POPUP_WIDTH'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_POPUP_WIDTH_DESC'),
					'std'=>'760',
					'placeholder'=>'780',
				),

				'modal_popup_height'=>array(
					'type'=>'number',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_POPUP_HEIGHT'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_POPUP_HEIGHT_DESC'),
					'std'=>'440',
					'placeholder'=>'440',
				),

				'alignment'=>array(
					'type'=>'alignment',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ALIGNMENT'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_MODAL_SELECTOR_ALIGNMENT_DESC'),
					'std'=>'center',
				),

				'class'=>array(
					'type'=>'text',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					'std'=>''
				),

			),
		),
	)
);
