<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

//Include Pixeden Icons (in Flex)
require_once dirname(dirname( __DIR__ )) . '/fields/pixeden-icons.php';

SpAddonsConfig::addonConfig([
    'type'       => 'content',
    'addon_name' => 'pie_progress',
    'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS'),
    'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_DESC'),
    'category'   => 'Content',
	'icon'       => '<svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M15.7 19.7c-1.7 0-3-1.3-3-3V7.6C7.3 8.1 3 12.7 3 18.3 3 24.2 7.8 29 13.7 29c2.8 0 5.4-1.1 7.5-3 1.7-1.7 2.8-3.9 3.2-6.2h-8.7v-.1zm10.7-1c-.1 3.3-1.5 6.4-3.9 8.7-2.4 2.3-5.5 3.6-8.9 3.6C6.7 31 1 25.3 1 18.3c0-7 5.7-12.7 12.7-12.7.5 0 1 .4 1 1v10.2c0 .6.4 1 1 1h9.8c.3 0 .5.1.7.3.2.1.2.4.2.6z" fill="currentColor"/><path opacity=".5" d="M17.8 1c-.5 0-1 .4-1 1v12.2c0 .5.4 1 1 1h11.8c.5 0 .9-.4 1-.9v-.4C30.5 6.7 24.8 1 17.8 1z" fill="currentColor"/></svg>',
    'settings' => [
        'progress' => [
            'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS'),
            'fields' => [
                'percentage' => [
                    'type'  => 'slider',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_PERCENTAGE'),
                    'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_PERCENTAGE_DESC'),
                    'min'   => 1,
                    'max'   => 100,
                    'std'   => 75,
                    'info'  => '%',
                ],

                'percentage_font_size' => [
                    'type'       => 'slider',
                    'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_FONT_SIZE'),
                    'std'        => ['xl' => 24],
                    'responsive' => true,
                    'max'        => 400,
                    'info'       => 'px',
                ],

                'size' => [
                    'type'  => 'slider',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_SIZE'),
                    'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_SIZE_DESC'),
                    'min'   => 50,
                    'max'   => 1000,
                    'std'   => 110,
                    'info'  => 'px',
                ],

                'animation_duration' => [
                    'type' => 'slider',
                    'title' => Text::_('COM_SPPAGEBUILDER_ANIMATION_DURATION'),
                    'desc' => Text::_('COM_SPPAGEBUILDER_ANIMATION_DURATION_DESC'),
					'std'  => 1500,
                    'info' => 'ms',
                ],

                'border_width' => [
                    'type'  => 'slider',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_BORDER_WIDTH'),
                    'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_BAR_WIDTH_DESC'),
                    'min'   => 1,
                    'max'   => 40,
                    'std'   => 5,
                    'info'  => 'px',
                ],

                'border_color' => [
                    'type'   => 'color',
                    'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_BAR'),
                    'std'    => 'rgba(217, 211, 128, 0.4)',
                ],

                'border_active_color' => [
                    'type'   => 'color',
                    'std'    => '#D1BC1F',
                    'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_PROGRESS'),
                ],

                'percentage_color' => [
                    'type'   => 'color',
                    'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_PIE_PROGRESS_PERCENTAGE'),
                    'std'    => '#574E18',
                ],
            ],
        ],

        'icon' => [
            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ICON'),
            'fields' => [
				
				 'peicon_name' => [
                    'type' =>'select',
    				'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PE_ICON_NAME'),
					'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PE_ICON_NAME_DESC'),
					'values' => $peicon_list,
					'std' => 'pe-7s-download',
                ],	
				
                'icon_name' => [
                    'type'  => 'icon',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ICON'),
                ],
				
				'icon_size' => [
                    'type'=>'slider',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_ICON_SIZE'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_ICON_SIZE_DESC'),
					'min'=>16,
					'max'=>500,
					'std'=>55,
					'info' => 'px',
                ],
				
				'icon_color' => [
                    'type'=>'color',
					'title'=>Text::_('FLEX_ADDON_ICON_TXT_COLOR'),
					'desc'=>Text::_('FLEX_ADDON_ICON_TXT_COLOR_DESC'),
                    'std'=>'#60591B',
                ],
            ]
        ],

        'content' => [
            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
            'fields' => [
                'text' => [
                    'type' => 'editor',
                    'std'  => 'Pie Progress is a type of circular progress view similar to the one that you can find in iOS devices while updating applications. Simple library where the progress gets updated by passing values to a single method.'
                ],

                'content_typography' => [
                    'type' => 'typography',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
                ],
            ],
        ],

        'title' => [
            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
            'fields' => [
                'title' => [
                    'type'  => 'text',
                    'title' => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE'),
                    'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
					'std'   => 'Pie Progress',
                ],

                'heading_selector' => [
                    'type'   => 'headings',
                    'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
                    'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
                    'std'   => 'h4',
                ],

                'title_typography' => [
                    'type'     => 'typography',
                    'title'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
                    'fallbacks'   => [
                        'font' => 'title_font_family',
                        'size' => 'title_fontsize',
                        'line_height' => 'title_lineheight',
                        'letter_spacing' => 'title_letterspace',
                        'uppercase' => 'title_font_style.uppercase',
                        'italic' => 'title_font_style.italic',
                        'underline' => 'title_font_style.underline',
                        'weight' => 'title_font_style.weight',
                    ],
                ],

                'title_text_color' => [
                    'type'   => 'color',
                    'title'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
                ],

                'title_margin_top' => [
                    'type'        => 'slider',
                    'title'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_TOP'),
                    'max'         => 400,
					'std'		  => 15,
                    'responsive'  => true
                ],

                'title_margin_bottom' => [
                    'type'        => 'slider',
                    'title'       => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_BOTTOM'),
                    'max'         => 400,
					'std'		  => 20,
                    'responsive'  => true
                ],
            ],
        ],
    ],
]);
