<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;


SpAddonsConfig::addonConfig([
	'type' => 'repeatable',
	'addon_name' => 'sp_lightbox',
	'title' => Text::_('FLEX_ADDON_IMAGELIGHTBOX'),
	'desc' => Text::_('FLEX_ADDON_IMAGELIGHTBOX_DESC'),
	'category' => 'Flex',
	'settings' => [
		'content' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
			'fields' => [
				'sp_lightbox_item' => [
					'type'	=> 'repeatable',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ITEMS'),
					'std'   => [
                            [
                                'thumb' => ['src' => 'https://images.unsplash.com/photo-1655139294116-0cf4b0d1d883?q=80&fm=jpg&w=400&h=200&auto=format&fit=crop'],
								'full' => ['src' => 'https://images.unsplash.com/photo-1655139294116-0cf4b0d1d883?q=80&fm=jpg&w=900&h=600&auto=format&fit=crop'],
                            ],
                            [
                                'thumb' => ['src' => 'https://images.unsplash.com/photo-1682687982029-edb9aecf5f89?q=80&fm=jpg&w=400&h=200&auto=format&fit=crop'],
								'full' => ['src' => 'https://images.unsplash.com/photo-1682687982029-edb9aecf5f89?q=80&fm=jpg&w=900&h=600&auto=format&fit=crop'],
								'show_caption'  => 1,
								'title'  => 'A person swimming in the water near kaleidoscopic-colored coral reefs | Islands of NEOM, Saudi Arabia',
                            ],
							[
                                'thumb' => ['src' => 'https://images.unsplash.com/photo-1682687980961-78fa83781450?q=80&fm=jpg&w=230&h=448&auto=format&fit=crop'],
								'full' => ['src' => 'https://images.unsplash.com/photo-1682687980961-78fa83781450?q=80&fm=jpg&w=800&h=800&auto=format&fit=crop'],
								'show_caption'  => 1,
								'title'  => 'Caption: The sun is setting over a desert landscape',
                            ],
							[
                                'thumb' => ['src' => 'https://images.unsplash.com/photo-1682687982167-d7fb3ed8541d?q=80&fm=jpg&w=400&h=200&auto=format&fit=crop'],
								'full' => ['src' => 'https://images.unsplash.com/photo-1682687982167-d7fb3ed8541d?q=80&fm=jpg&w=900&h=560&auto=format&fit=crop'],
                            ],
							[
                                'thumb' => ['src' => 'https://images.unsplash.com/photo-1484591974057-265bb767ef71?q=80&fm=jpg&w=400&h=270&auto=format&fit=crop'],
								'full' => ['src' => 'https://images.unsplash.com/photo-1484591974057-265bb767ef71?q=80&fm=jpg&w=900&h=600&auto=format&fit=crop'],
                            ],
							[
                                'thumb' => ['src' => 'https://images.unsplash.com/photo-1682687221175-fd40bbafe6ca?q=80&w=450&h=236&auto=format&fit=crop'],
								'full' => ['src' => 'https://images.unsplash.com/photo-1682687221175-fd40bbafe6ca?q=80&w=900&h=580&auto=format&fit=crop'],
                            ],
							[
                                'thumb' => ['src' => 'https://images.unsplash.com/photo-1618356387617-8d2f8cfbc79c?q=80&w=230&h=316&auto=format&fit=crop'],
								'full' => ['src' => 'https://images.unsplash.com/photo-1618356387617-8d2f8cfbc79c?q=80&w=660&h=820&auto=format&fit=crop'],
								'show_caption'  => 1,
								'title'  => 'Delta Lake - Grand Teton National Park',
                            ],
							[
                            	'thumb' => ['src' => 'https://images.unsplash.com/photo-1519681393784-d120267933ba?q=80&w=400&h=320&auto=format&fit=crop'],
								'full' => ['src' => 'https://images.unsplash.com/photo-1519681393784-d120267933ba?q=80&w=900&h=480&auto=format&fit=crop'],
                            ],
							[
                                'thumb' => ['src' => 'https://images.unsplash.com/photo-1682686581413-0a0ec9bb35bb?q=80&w=400&h=260&auto=format&fit=crop'],
								'full' => ['src' => 'https://images.unsplash.com/photo-1682686581413-0a0ec9bb35bb?q=80&w=900&h=620&auto=format&fit=crop'],
                            ],
                        ],

					'attr'  => [
						'title' => [
							'type'  => 'text',
							'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_ITEM_TITLE'),
							'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_ITEM_TITLE_DESC'),
							'std'   => 'Lightbox Item'
						],

						'thumb' => [
							'type'  => 'media',
							'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_THUMB'),
							'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_THUMB_DESC'),
							'std'   => [
								'src'    => 'https://images.unsplash.com/photo-1655139294116-0cf4b0d1d883?q=80&w=400&h=200&auto=format&fit=crop',
								'height' => '',
								'width'  => '',
							],
						],

						'full' => [
							'type'  => 'media',
							'title' => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_FULL'),
							'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_FULL_DESC'),
							'std'   => [
								'src'    => 'https://images.unsplash.com/photo-1655139294116-0cf4b0d1d883?q=80&w=800&h=400&auto=format&fit=crop',
								'height' => '',
								'width'  => '',
							],
						],

						'caption_separator' => [
							'type' => 'separator',
						],
						
						'show_caption' => [
							'type'   => 'checkbox',
							'title'=>Text::_('FLEX_ADDON_IMAGELIGHTBOX_SHOW_CAPTION'),
							'desc'=>Text::_('FLEX_ADDON_IMAGELIGHTBOX_SHOW_CAPTION_DESC'),
							'values' => [
								1 => Text::_('JYES'),
								0 => Text::_('JNO'),
							],
							'std' => 1,
						],
					],
				],
			],
		],

		'options' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_OPTIONS'),
			'fields' => [
				'width' => [
					'type' => 'slider',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_IMAGE_WIDTH'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GALLERY_IMAGE_WIDTH_DESC'),
					//'responsive' => true,
					//'std' => ['xl' => 260],
					'min' => 20,
					'max' => 1000,
					'std'=> 180,
				],

				'spacing' => [
					'type' => 'slider',
					'title'=>Text::_('FLEX_THUMBNAIL_SPACING'),
					'desc'=>Text::_('FLEX_THUMBNAIL_SPACING_DESC'),
					//'responsive' => true,			
					//'min' => 0,
					'max' => 80,
					'std' => 12,
				],
				
				'class' => [
					'type' => 'text',
					'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					'std' => '',
				],
			]
		],

		'title' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
			'fields' => [
				'title' => [
					'type'  => 'text',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
				],

				'heading_selector' => [
					'type'   => 'headings',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_HEADINGS_DESC'),
					'std'   => 'h3',
				],

				'title_typography' => [
					'type'     => 'typography',
					'title'  	=> Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'fallbacks'   => [
						'font' => 'title_font_family',
						'size' => 'title_fontsize',
						'line_height' => 'title_lineheight',
						'letter_spacing' => 'title_letterspace',
						'uppercase' => 'title_font_style.uppercase',
						'italic' => 'title_font_style.italic',
						'underline' => 'title_font_style.underline',
						'weight' => 'title_font_style.weight',
					],
				],

				'title_text_color' => [
					'type'   => 'color',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
				],

				'title_margin_separator' => [
					'type' => 'separator',
				],

				'title_margin_top' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_TOP'),
					'max'        => 400,
					'responsive' => true,
				],

				'title_margin_bottom' => [
					'type'       => 'slider',
					'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_MARGIN_BOTTOM'),
					'max'        => 400,
					'responsive' => true,
				],
			],
		],
	],
]);
