<?php
/**
 * Flex @package Helix Framework
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Helper\AuthenticationHelper;

$doc = Factory::getDocument();
$app = Factory::getApplication();

$twofactormethods	= [];

if(version_compare(JVERSION, '4.2.0', '<'))
{
	$twofactormethods 	= AuthenticationHelper::getTwoFactorMethods();
}

//Load Helix
$helix3_path = JPATH_PLUGINS . '/system/helix3/core/helix3.php';

if (file_exists($helix3_path))
{
	require_once($helix3_path);
	// Deprecated: $this->helix3 = helix3::getInstance();
	$helix3 = helix3::getInstance();
}
else
{
	die('Please install and activate helix plugin');
}

// Remove the generator meta tag
if($helix3->getParam('remove_joomla_generator')) {
  $doc->setGenerator(null);
}

$offline_date = explode('-', $this->params->get("offline_date"));

?>
<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php
    if($favicon = $this->params->get('favicon')) {
        $doc->addFavicon( Uri::base(true) . '/' .  $favicon);
    } else {
        $doc->addFavicon( $this->baseurl . '/templates/'. $this->template .'/images/favicon.ico' );
    }
	
	$helix3->addCSS('bootstrap.min.css, template.css, fontawesome.min.css, fa-v4-shims.css')
    	->addJS('bootstrap.min.js, main.js, jquery.countdown.min.js');

	//Custom CSS
	if ($custom_css = $helix3->getParam('custom_css')) {
		$doc->addStyledeclaration($custom_css);
	}

	//Custom JS
	if ($custom_js = $helix3->getParam('custom_js')) {
		$doc->addScriptdeclaration($custom_js);
	}
	//Custom background image
	if($offline_bg_image = $helix3->getParam('offline_bg_image')) {
		
		$offline_bg = 'background-color: transparent;';
		$offline_bg .= 'background-image: url(' . Uri::base(true ) . '/' . $offline_bg_image . ');';
		$offline_bg .= 'background-repeat: no-repeat;';
		$offline_bg .= 'background-size: cover;';
		$offline_bg .= 'background-attachment: fixed;';
		$offline_bg .= 'background-position: 50% 50%;';
		$offline_bg = 'body {' . $offline_bg . '}'; 
	
		$doc->addStyledeclaration( $offline_bg );
	}
	
	//Body Font
	$webfonts = array();
	
	if( $this->params->get('enable_body_font') ) {
		$webfonts['.offline-container'] = $this->params->get('body_font');
	}
	//Heading1 Font
	if( $this->params->get('enable_h1_font') ) {
		$webfonts['h1'] = $this->params->get('h1_font');
	}
	
	$helix3->addGoogleFont($webfonts);
	
	if($offline_bg_image = $helix3->getParam('offline_bg_image')) {
		$style = ' style="box-shadow: 0 3px 20px rgba(10,10,10,.2);margin:2vh auto;"';
	} else {
		$style = '';
	}
    ?>
<jdoc:include type="head" /> 
<body>
	<div class="container offline-container">
		
		<div class="row centered py-2 mx-auto">
			<!-- Message alert: -->
			<div class="z-3 col-10 col-lg-6 mt-1 position-absolute top-0 start-50 translate-middle-x"><jdoc:include type="message" /></div>
			  <div class="col-sm-9 col-lg-8">
				 <div<?php echo $style; ?> class="offline-inner row py-5 py-md-3">
				    <div id="frame" class="outline container text-center">
						<?php if ($app->get('offline_image')) { ?>
							<div class="centered-logo col-md-10 py-2">
								<img style="max-height:135px;" class="centered-logo" src="<?php echo $app->get('offline_image'); ?>" srcset="<?php echo $app->get('offline_image'); ?> 2x" alt="<?php echo htmlspecialchars($app->get('sitename')); ?>" />
                            </div>
						<?php } else { ?>
						<h1 class="pt-1 pb-2 mx-auto" style="text-align:center;font-size:220%;font-weight:400;text-shadow:0 1px 1px rgba(255,255,255,.3);">
							<?php echo htmlspecialchars($app->get('sitename')); ?>
						</h1>
                        <?php } ?>
						<?php if ($app->get('display_offline_message', 1) == 1 && str_replace(' ', '', $app->get('offline_message')) != '') : ?>
							<div style="text-shadow:0 1px 1px rgba(255,255,255,.3);" class="offline_message container mt-3 mb-0 px-0 py-1">
								<div class="col-10 col-md-11 col-lg-7 text-start me-md-3 me-lg-0 px-1">
									<div class="px-1">
										<div class="float-start me-3 mb-2 ps-0 pt-1">
											<svg xmlns="http://www.w3.org/2000/svg" style="--fa-animation-duration: 6s;" width="37" height="37" fill="rgba(44,44,44,0.2)" class="fa-shake fa-spin" viewBox="0 0 16 16"><path d="M8 4.754a3.246 3.246 0 1 0 0 6.492 3.246 3.246 0 0 0 0-6.492M5.754 8a2.246 2.246 0 1 1 4.492 0 2.246 2.246 0 0 1-4.492 0"/><path d="M9.796 1.343c-.527-1.79-3.065-1.79-3.592 0l-.094.319a.873.873 0 0 1-1.255.52l-.292-.16c-1.64-.892-3.433.902-2.54 2.541l.159.292a.873.873 0 0 1-.52 1.255l-.319.094c-1.79.527-1.79 3.065 0 3.592l.319.094a.873.873 0 0 1 .52 1.255l-.16.292c-.892 1.64.901 3.434 2.541 2.54l.292-.159a.873.873 0 0 1 1.255.52l.094.319c.527 1.79 3.065 1.79 3.592 0l.094-.319a.873.873 0 0 1 1.255-.52l.292.16c1.64.893 3.434-.902 2.54-2.541l-.159-.292a.873.873 0 0 1 .52-1.255l.319-.094c1.79-.527 1.79-3.065 0-3.592l-.319-.094a.873.873 0 0 1-.52-1.255l.16-.292c.893-1.64-.902-3.433-2.541-2.54l-.292.159a.873.873 0 0 1-1.255-.52zm-2.633.283c.246-.835 1.428-.835 1.674 0l.094.319a1.873 1.873 0 0 0 2.693 1.115l.291-.16c.764-.415 1.6.42 1.184 1.185l-.159.292a1.873 1.873 0 0 0 1.116 2.692l.318.094c.835.246.835 1.428 0 1.674l-.319.094a1.873 1.873 0 0 0-1.115 2.693l.16.291c.415.764-.42 1.6-1.185 1.184l-.291-.159a1.873 1.873 0 0 0-2.693 1.116l-.094.318c-.246.835-1.428.835-1.674 0l-.094-.319a1.873 1.873 0 0 0-2.692-1.115l-.292.16c-.764.415-1.6-.42-1.184-1.185l.159-.291A1.873 1.873 0 0 0 1.945 8.93l-.319-.094c-.835-.246-.835-1.428 0-1.674l.319-.094A1.873 1.873 0 0 0 3.06 4.377l-.16-.292c-.415-.764.42-1.6 1.185-1.184l.292.159a1.873 1.873 0 0 0 2.692-1.115z"/></svg><svg xmlns="http://www.w3.org/2000/svg" style="--fa-animation-duration: 6s;--fa-animation-direction: reverse;margin-left:-2px;margin-top:12px;" width="26" height="26" fill="rgba(206,34,0,0.25)" class="fa-shake fa-spin" viewBox="0 0 16 16"><path d="M8 4.754a3.246 3.246 0 1 0 0 6.492 3.246 3.246 0 0 0 0-6.492M5.754 8a2.246 2.246 0 1 1 4.492 0 2.246 2.246 0 0 1-4.492 0"/><path d="M9.796 1.343c-.527-1.79-3.065-1.79-3.592 0l-.094.319a.873.873 0 0 1-1.255.52l-.292-.16c-1.64-.892-3.433.902-2.54 2.541l.159.292a.873.873 0 0 1-.52 1.255l-.319.094c-1.79.527-1.79 3.065 0 3.592l.319.094a.873.873 0 0 1 .52 1.255l-.16.292c-.892 1.64.901 3.434 2.541 2.54l.292-.159a.873.873 0 0 1 1.255.52l.094.319c.527 1.79 3.065 1.79 3.592 0l.094-.319a.873.873 0 0 1 1.255-.52l.292.16c1.64.893 3.434-.902 2.54-2.541l-.159-.292a.873.873 0 0 1 .52-1.255l.319-.094c1.79-.527 1.79-3.065 0-3.592l-.319-.094a.873.873 0 0 1-.52-1.255l.16-.292c.893-1.64-.902-3.433-2.541-2.54l-.292.159a.873.873 0 0 1-1.255-.52zm-2.633.283c.246-.835 1.428-.835 1.674 0l.094.319a1.873 1.873 0 0 0 2.693 1.115l.291-.16c.764-.415 1.6.42 1.184 1.185l-.159.292a1.873 1.873 0 0 0 1.116 2.692l.318.094c.835.246.835 1.428 0 1.674l-.319.094a1.873 1.873 0 0 0-1.115 2.693l.16.291c.415.764-.42 1.6-1.185 1.184l-.291-.159a1.873 1.873 0 0 0-2.693 1.116l-.094.318c-.246.835-1.428.835-1.674 0l-.094-.319a1.873 1.873 0 0 0-2.692-1.115l-.292.16c-.764.415-1.6-.42-1.184-1.185l.159-.291A1.873 1.873 0 0 0 1.945 8.93l-.319-.094c-.835-.246-.835-1.428 0-1.674l.319-.094A1.873 1.873 0 0 0 3.06 4.377l-.16-.292c-.415-.764.42-1.6 1.185-1.184l.292.159a1.873 1.873 0 0 0 2.692-1.115z"/></svg>
										</div>
										<?php echo $app->get('offline_message'); ?>
									</div>
								</div>
							</div>
						<?php elseif ($app->get('display_offline_message', 1) == 2 && str_replace(' ', '', Text::_('JOFFLINE_MESSAGE')) != '') : ?>
							<p style="text-align:center;" class="offline_message container mt-3 mb-0 px-0 py-1"><?php echo Text::_('JOFFLINE_MESSAGE'); ?></p>
						<?php endif; ?>
                
						<form action="<?php echo Route::_('index.php', true); ?>" method="post" id="form-login">
							<div class="form-group" id="form-login-username">
								<input name="username" id="username" type="text" class="form-control" placeholder="<?php echo Text::_('JGLOBAL_USERNAME'); ?>" size="18" />
							</div>
							<div class="form-group" id="form-login-password">
								<input type="password" name="password" class="form-control" size="18" placeholder="<?php echo Text::_('JGLOBAL_PASSWORD'); ?>" id="passwd" />
							</div>
							<?php if (count($twofactormethods) > 1) : ?>
							<div class="form-group" id="form-login-secretkey">
								<input type="text" name="secretkey" class="form-control" size="18" placeholder="<?php echo Text::_('JGLOBAL_SECRETKEY'); ?>" id="secretkey" />
							</div>
							<?php endif; ?>
							<div class="form-group" id="submit-buton">
								<input style="text-shadow:0 1px 1px rgba(5,5,5,.3);" type="submit" name="Submit" class="btn btn-readmore btn-3d login px-5" value="<?php echo Text::_('JLOGIN'); ?>" />
							</div>
							
							<input type="hidden" name="option" value="com_users" />
							<input type="hidden" name="task" value="user.login" />
							<input type="hidden" name="return" value="<?php echo base64_encode(Uri::base()); ?>" />
							<?php echo HTMLHelper::_('form.token'); ?>
							
						</form>
					</div>
                    <?php if( $this->params->get('comingsoon_counter') ) { ?>
                    <hr class="pt-0 pb-2 my-0" />
					<div class="sp-comingsoon-content">
						<svg xmlns="http://www.w3.org/2000/svg" style="--fa-animation-duration: 3s;--fa-animation-timing: ease-in-out;--fa-animation-delay: 3s;margin-top:-3px;" width="23" height="21" fill="rgba(180,31,2,0.5)" class="fa-shake mx-2" viewBox="0 0 16 16"><path d="M8.515 1.019A7 7 0 0 0 8 1V0a8 8 0 0 1 .589.022zm2.004.45a7 7 0 0 0-.985-.299l.219-.976q.576.129 1.126.342zm1.37.71a7 7 0 0 0-.439-.27l.493-.87a8 8 0 0 1 .979.654l-.615.789a7 7 0 0 0-.418-.302zm1.834 1.79a7 7 0 0 0-.653-.796l.724-.69q.406.429.747.91zm.744 1.352a7 7 0 0 0-.214-.468l.893-.45a8 8 0 0 1 .45 1.088l-.95.313a7 7 0 0 0-.179-.483m.53 2.507a7 7 0 0 0-.1-1.025l.985-.17q.1.58.116 1.17zm-.131 1.538q.05-.254.081-.51l.993.123a8 8 0 0 1-.23 1.155l-.964-.267q.069-.247.12-.501m-.952 2.379q.276-.436.486-.908l.914.405q-.24.54-.555 1.038zm-.964 1.205q.183-.183.35-.378l.758.653a8 8 0 0 1-.401.432z"/><path d="M8 1a7 7 0 1 0 4.95 11.95l.707.707A8.001 8.001 0 1 1 8 0z"/><path d="M7.5 3a.5.5 0 0 1 .5.5v5.21l3.248 1.856a.5.5 0 0 1-.496.868l-3.5-2A.5.5 0 0 1 7 9V3.5a.5.5 0 0 1 .5-.5"/></svg><span style="font-size:90%;text-shadow:0 1px 1px rgba(255,255,255,.4);margin-left:2px;"><?php echo $this->params->get('offline_content'); ?></span>
					</div>
               	    <div style="text-shadow:0 1px 2px rgba(255,255,255,.35);" id="sp-comingsoon-countdown" class="sp-comingsoon-countdown"></div>
					<?php } ?>		
				</div>
			</div>
		</div>
	</div>
    <script type="text/javascript">
		jQuery(function($) {
			$('#sp-comingsoon-countdown').countdown('<?php echo trim($offline_date[2]); ?>/<?php echo trim($offline_date[1]); ?>/<?php echo trim($offline_date[0]); ?>', function(event) {
			    $(this).html(event.strftime('<div style="box-shadow:0 2px 1px rgba(10,10,10,.2);" class="days rounded"><span class="number">%-D</span><span class="string">%!D:<?php echo Text::_("HELIX_DAY"); ?>,<?php echo Text::_("HELIX_DAYS"); ?>;</span></div><div style="box-shadow:0 2px 1px rgba(10,10,10,.2);" class="hours rounded"><span class="number">%H</span><span class="string">%!H:<?php echo Text::_("HELIX_HOUR"); ?>,<?php echo Text::_("HELIX_HOURS"); ?>;</span></div><div style="box-shadow:0 2px 1px rgba(10,10,10,.2);" class="minutes rounded"><span class="number">%M</span><span class="string">%!M:<?php echo Text::_("HELIX_MINUTE"); ?>,<?php echo Text::_("HELIX_MINUTES"); ?>;</span></div><div style="box-shadow:0 2px 1px rgba(10,10,10,.2);" class="seconds rounded"><span class="number">%S</span><span class="string">%!S:<?php echo Text::_("HELIX_SECOND"); ?>,<?php echo Text::_("HELIX_SECONDS"); ?>;</span></div>'));
			});
		});
	</script>
</body>
</html>

