<?php
/**
 * Flex @package Helix3 Framework
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
defined('_JEXEC') or die;

use Joomla\CMS\Filter\OutputFilter;

//Helix3
helix3::addLess('frontend-edit', 'frontend-edit');
helix3::addJS('frontend-edit.js');

$helix3_path = JPATH_PLUGINS.'/system/helix3/core/helix3.php';
if (file_exists($helix3_path))
{
    require_once($helix3_path);
    $helix3 = Helix3::getInstance();
}
//Add Helix to include "above-component" and "below-component" module positions

$data = $displayData;

$output ='';


$output .= '<div id="sp-component" class="' . $data->className . '">';

$output .= '<div class="sp-column ' . ($data->settings->custom_class) . '">';
$output .= '<jdoc:include type="message" />';

if ($helix3->countModules('above-component')) {
	$output .= '<div class="above-component"><jdoc:include type="modules" name="above-component" /></div>';
}
$output .= '<jdoc:include type="component" />';
if ($helix3->countModules('below-component')) {
	$output .= '<div class="below-component"><jdoc:include type="modules" name="below-component" style="none" /></div>';
}
$output .= '</div>';

$output .= '</div>';

if ($helix3->countModules('above-component') || $helix3->countModules('below-component')) {
		// Only "left" or "right" module positions
}
echo $output;

