<?php
/**
 * Flex @package Layout for the add to cart popup
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

$media_model 	= VmModel::getModel('media');
$product_model 	= VmModel::getModel('product');

if (!class_exists('CurrencyDisplay')) require(VMPATH_ADMIN . DS . 'helpers' . DS . 'currencydisplay.php');
$currency = CurrencyDisplay::getInstance( );
?>
<style>
.checkmark {
    width: 30px;
    height: 30px;
    border-radius: 50%;
    stroke-width: 3;
    stroke: #4bb71b;
    stroke-miterlimit: 10;
    box-shadow: inset 0px 0px 0px #4bb71b;
    animation: fill .5s ease-in-out 1.4s forwards, scale .8s ease-in-out 2.4s both;
    position:relative;
    margin: -7px 0 0 9px;
}
.checkmark__circle {
    stroke-dasharray: 166;
    stroke-dashoffset: 166;
    stroke-width: 3;
    stroke-miterlimit: 10;
    stroke: #4bb71b;
    fill: #fff;
    animation: stroke 0.7s cubic-bezier(0.65, 0, 0.45, 1) 1s both;
}
.checkmark__check {
    transform-origin: 50% 50%;
    stroke-dasharray: 48;
    stroke-dashoffset: 48;
    animation: stroke 0.6s cubic-bezier(0.65, 0, 0.45, 1) 1.8s forwards;
}	
.fade-in-left{
	animation: fade-in-left 0.9s cubic-bezier(0.6, 0, 0.3, 1.1) .4s both;
}	
.fade-zoomin{
	animation: fade-zoomin .9s cubic-bezier(0.6, 0, 0.3, 1.2) .1s both;
}
.fade-in-up{
	animation: fade-in-up 1s cubic-bezier(0.4, 0, 0.2, 1.1) both;
}
.simple-fade {
	animation: simple-fade .7s ease .2s both;
}
@keyframes stroke {
	0% {
		visibility:hidden;
	}
    100% {
        visibility:visible;
		stroke-dashoffset: 0;
    }
}
@keyframes scale {
    0%, 100% {
        transform: none;
    }

    50% {
        transform: scale3d(1.2, 1.2, 1);
    }
}
@keyframes fill {
    100% {
		box-shadow: inset 0px 0px 0px 15px #4bb71b;
    }
}
@keyframes fade-in-left{
	0% {
		opacity: 0;
        transform:translate3d(50px,0,0);
	  }
    100%{
        opacity:1;
        transform:none;
    }
}	
@keyframes fade-zoomin{
	0% {
		opacity: 0;
		visibility:hidden;
        transform: scale3d(0.85, 0.85, 1);
	}
    100%{
        opacity:1;
		visibility:visible;
        transform: scale3d(1, 1, 1);
    }
}
</style>
<!-- popup cart -->
<div class="popup-cart row px-0 mx-0">
  <?php if($this->products){ ?>
	<h3 class="title d-block centered pt-3 pb-0 px-0 mx-auto"><span class="simple-fade"><?php echo Text::_('VM_POPUP_PRODUCT_ADDED_SUCCESS'); ?></span> 
		<span class="mt-1 d-block"><span class="d-inline-block mt-2 fade-in-left"><?php echo Text::_('VM_POPUP_YOUR_SH0PPING_CART'); ?></span><svg class="checkmark" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 55 52"><circle class="checkmark__circle" cx="28" cy="26" r="26" fill="none" /><path class="checkmark__check" fill="none" d="M16 27.2l7.1 7.2 16.7-16.8" /></svg></span>
	</h3>
	
	<div class="item-wrap mx-auto my-0 px-0 text-start fade-zoomin">
<?php if ($this->products and is_array($this->products) and count($this->products)>0 ) {
	foreach($this->products as $product) {
		if($product->quantity>0){
			$images  = $media_model->createMediaByIds($product->virtuemart_media_id, $product->quantity); 
			$prices  = $product_model->getPrice($product->virtuemart_product_id, 1);
			?>
			<div class="col-12 col-sm-6 col-md-5 col-lg-4 px-5 px-sm-2 p-md-1 ps-lg-4 pe-lg-0 mb-4 mb-sm-3 float-start">
				<?php if(isset($images[0]) && $images[0]) {
					echo $images[0]->displayMediaThumb ('class="ProductImage rounded-1"', FALSE); 
				} ?>	
			</div>
			<div class="col-12 col-sm-6 col-md-7 col-lg-8 mt-0 mb-0 mt-md-2 px-4 text-center text-sm-start float-start">
				<h3 class="item-name mt-0 py-0"><?php echo $product->product_name; ?></h3>
				<div class="vm-price-box">
					<?php if ( isset($product->allPrices[0]['product_override_price']) && round($product->allPrices[0]['product_override_price']) != 0) { ?>
						<ins>
							<?php echo $currency->createPriceDiv ('salesPrice', '', $prices, FALSE, FALSE, 1.0, TRUE); ?>
							<?php echo $currency->createPriceDiv ('salesPriceTt', '', $prices, FALSE, FALSE, 1.0, TRUE); ?>
						</ins>
						<del>    
							<?php echo $currency->createPriceDiv ('basePriceVariant', '', $prices, FALSE, FALSE, 1.0, TRUE); ?>
						</del>
					<?php } else{ ?>
						<ins>
							<?php echo $currency->createPriceDiv ('salesPrice', '', $prices, FALSE, FALSE, 1.0, TRUE); ?>
							<?php echo $currency->createPriceDiv ('salesPriceTt', '', $prices, FALSE, FALSE, 1.0, TRUE); ?>
						</ins>
					<?php } ?>
				</div>
				<?php 
					if($product->quantity>0){
					$quantity = isset($product->quantityAdded)? $product->quantityAdded: $product->quantity;
				?>
				<p class="popup-cart-product-quantity">
					<span><?php echo Text::_('VM_POPUP_SH0PPING_CART_QUANTITY'); ?> </span>
					<?php 
						if($product->quantity>0){
							$quantity = isset($product->quantityAdded) ? $product->quantityAdded : $product->quantity;
							echo '<span class="badge bg-secondary fs-6 pe-va">'. $quantity .'</span>';
						}
					?>
				</p>
				<?php } ?>
			</div>
		<?php } else { 
			
				if(!empty($product->errorMsg)){
					echo '<div>'.$product->errorMsg.'</div>';
				}
			} // else
		} // END:: foreach
	} // has product 
} ?>
  </div> <!-- //item-wrap -->
	<div class="button-group row col-10 col-sm-8 col-md-11 col-lg-10 px-0 mx-auto pb-2 mt-1 mt-md-4 d-block d-lg-flex justify-content-center">
		<a class="continue_link col-12 col-sm-6 col-md-6 ms-0 mx-lg-2 mt-3 mt-sm-0 px-md-2 px-lg-0" href="<?php echo $this->continue_link; ?>" >
			<?php echo vmText::_('COM_VIRTUEMART_CONTINUE_SHOPPING'); ?> 
		</a>
		<a class="showcart col-12 col-sm-6 col-md-6 mx-0 mx-lg-2" href="<?php echo  $this->cart_link; ?>">
			<?php echo vmText::_('COM_VIRTUEMART_CART_SHOW'); ?><svg xmlns="http://www.w3.org/2000/svg" style="margin:-6px -8px 0 10px" width="15" height="15" fill="currentColor" class="bi" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M10.854 8.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 0 1 .708-.708L7.5 10.793l2.646-2.647a.5.5 0 0 1 .708 0"/><path d="M8 1a2.5 2.5 0 0 1 2.5 2.5V4h-5v-.5A2.5 2.5 0 0 1 8 1m3.5 3v-.5a3.5 3.5 0 1 0-7 0V4H1v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4zM2 5h12v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1z"/></svg>
		</a>
	</div> <!-- //button-group -->

</div> <!-- //.popup-cart -->
<br style="clear:both">



