<?php
/**
 * Flex @package Helix Ultimate Framework
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;

class Helix3FeatureMenu {

	private $helix3;
	public $position;

	public function __construct($helix3){
		$this->helix3 = $helix3;
		$this->position = 'menu';
	}

	public function renderFeature() {
		
		$doc = Factory::getDocument();

		$menu_type = $this->helix3->getParam('menu_type');
		$offcanvas_icon_color = $this->helix3->getParam('offcanvas_icon_color');
		$offcanvas_icon_class = '';
		$offcanvas_icon_size = '';
		$offcanvas_color = '';
	
		
		if ($this->helix3->getParam('offcanvas_icon') == 3) {
			// FontAwesome icon 
			$offcanvas_icon_class .= 'fas fa-bars';
			
			if ($offcanvas_icon_color != ''){
				$offcanvas_color = 'color:'. $offcanvas_icon_color .';';
			}
			
		} else if ($this->helix3->getParam('offcanvas_icon') == 4) {
			// Pixeden icon 
			$offcanvas_icon_class .= 'pe pe-7s-menu';
			if ($offcanvas_icon_color != ''){
				$offcanvas_color = 'color:'. $offcanvas_icon_color .';';
			}
			
		} else if ($this->helix3->getParam('offcanvas_icon') == 2) {
			//Bootstrap icon (SVG)
			$offcanvas_icon_class .= '';
			if ($offcanvas_icon_color != ''){
				$offcanvas_color = $offcanvas_icon_color;
			} else {
				$offcanvas_color = 'currentColor';
			}
		} else {
			//Animated icon
			$offcanvas_icon_class .= '';
			
			if ($offcanvas_icon_color != ''){
				$offcanvas_color = 'background-color:'. $offcanvas_icon_color .'!important;';
			}
		}
		
		if ($this->helix3->getParam('offcanvas_icon_size') != '') {
			$offcanvas_icon_size = $this->helix3->getParam('offcanvas_icon_size');
		} else {
			$offcanvas_icon_size = 20;
		}
		
		// Add styles
		$style = '';
		// Animated icon
		if ($this->helix3->getParam('offcanvas_icon') == 1) {
			$style .= '.js-menu-toggle .lines, .js-menu-toggle .lines:before, .js-menu-toggle .lines:after {width:' . $offcanvas_icon_size .'px!important; '. $offcanvas_color .'}';
		}
		// FontAwesome or Pixeden icons
		if ($this->helix3->getParam('offcanvas_icon') == 3 || $this->helix3->getParam('offcanvas_icon') == 4) {
			$style .= '#offcanvas-toggler > i.offcanvas-icon {font-size:'. $offcanvas_icon_size .'px;'. $offcanvas_color .'}';
		}
		
		if ($this->helix3->getParam('offcanvas_icon_size') < 26) {
			if ($this->helix3->getParam('offcanvas_icon') == 2) {
				$style .= '
				@media (max-width: 768px) {
				  .bootstrap-list-icon {
					width:'. ( $offcanvas_icon_size * 1.6 ) .'px!important;
					height:'. ( $offcanvas_icon_size * 1.6 ) .'px!important;
				  }
				}';
			} else if ($this->helix3->getParam('offcanvas_icon') == 3 || $this->helix3->getParam('offcanvas_icon') == 4) {
				$style .= '
				@media (max-width: 768px) {
				  #offcanvas-toggler > i.offcanvas-icon {
					font-size:'. ( $offcanvas_icon_size * 1.3 ) .'px;
				  }
				}';
			} else {
				$style .= '
				@media (max-width: 768px) {
				  .js-menu-toggle .lines, .js-menu-toggle .lines:before, .js-menu-toggle .lines:after {width:'. ( $offcanvas_icon_size * 1.25 ) .'px!important;}

				  .js-menu-toggle .lines {
				  	-webkit-transform: scale(1.1,1.3);
					transform: scale(1.1,1.3);
				  }
				}';
			}
		} else {
			if ($this->helix3->getParam('offcanvas_icon') == 1) {
				$style .= '
				@media (max-width: 768px) {
				  .js-menu-toggle .lines {
				  	-webkit-transform: scale(1.1,1.4);
					transform: scale(1.1,1.4);
				  }
				}';
			}
		}
		$doc->addStyleDeclaration($style);
		
		ob_start();
		
		if($menu_type == 'mega_offcanvas') { ?>
			<div class="sp-megamenu-wrapper d-block d-lg-flex justify-content-end mx-0 px-0 gx-0">
				<?php $this->helix3->loadMegaMenu('d-none d-lg-flex justify-content-center mx-0 px-0 gx-0'); ?>
				<a id="offcanvas-toggler" class="hstack d-lg-flex justify-content-center me-3 me-md-0" href="#" aria-label="<?php echo Text::_('HELIX_MENU'); ?>">
					<?php if ($this->helix3->getParam('offcanvas_icon') == 1) { ?>
						<?php // Animated icon ?>
						<span class="js-menu-toggle d-block w-100 d-flex justify-content-center">
							<span class="lines"></span>
						</span>
					<?php } else if ($this->helix3->getParam('offcanvas_icon') == 2 ) { ?>
						<?php // Boottsrap icon ?>
						<svg xmlns="http://www.w3.org/2000/svg" width="<?php echo ( $offcanvas_icon_size + 6 ); ?>" height="<?php echo ( $offcanvas_icon_size + 6 ); ?>" fill="<?php echo $offcanvas_color; ?>" class="major_color-lighten-10 bootstrap-list-icon" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5"/></svg>
					<?php } else if ($this->helix3->getParam('offcanvas_icon') == 3 || $this->helix3->getParam('offcanvas_icon') == 4) { ?>
						<?php // Font Awesome and Pixeden icons; ?>
						<i class="<?php echo $offcanvas_icon_class; ?> offcanvas-icon" aria-hidden="true" title="<?php echo Text::_('HELIX_MENU'); ?>"></i>
					<?php } ?>
				</a>
			</div>
		<?php } else if ($menu_type == 'mega') { ?>
			<div class="sp-megamenu-wrapper">
				<?php $this->helix3->loadMegaMenu('d-none d-lg-flex justify-content-center mx-0 px-0 gx-0'); ?>
				<a id="offcanvas-toggler" class="d-block d-flex d-lg-none hstack justify-content-center me-3 me-md-0" href="#" aria-label="<?php echo Text::_('HELIX_MENU'); ?>">
					<?php if ($this->helix3->getParam('offcanvas_icon') == 1) { ?>
						<?php // Animated icon ?>
						<span class="js-menu-toggle d-block w-100 d-flex justify-content-center">
							<span class="lines"></span>
						</span>
					<?php } else if ($this->helix3->getParam('offcanvas_icon') == 2 ) { ?>
						<?php // Boottsrap icon ?>
						<svg xmlns="http://www.w3.org/2000/svg" width="<?php echo ( $offcanvas_icon_size + 6 ); ?>" height="<?php echo ( $offcanvas_icon_size + 6 ); ?>" fill="<?php echo $offcanvas_color; ?>" class="major_color-lighten-10 bootstrap-list-icon" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5"/></svg>
					<?php } else if ($this->helix3->getParam('offcanvas_icon') == 3 || $this->helix3->getParam('offcanvas_icon') == 4) { ?>
						<?php // Font Awesome and Pixeden icons; ?>
						<i class="<?php echo $offcanvas_icon_class; ?> offcanvas-icon" aria-hidden="true" title="<?php echo Text::_('HELIX_MENU'); ?>"></i>
					<?php } ?>
				</a>
			</div>
		<?php } else { ?>
			<div class="sp-megamenu-wrapper">
				<a id="offcanvas-toggler" class="hstack d-flex justify-content-center me-3 me-sm-3 me-md-0 px-0 px-sm-0 px-md-0 px-lg-3" href="#" aria-label="<?php echo Text::_('HELIX_MENU'); ?>">
					<?php if ($this->helix3->getParam('offcanvas_icon') == 1) { ?>
						<?php // Animated icon ?>
						<span class="js-menu-toggle d-flex justify-content-center">
							<span class="lines"></span>
						</span>
					<?php } else if ($this->helix3->getParam('offcanvas_icon') == 2 ) { ?>
						<?php // Boottsrap icon ?>
						<svg xmlns="http://www.w3.org/2000/svg" width="<?php echo ( $offcanvas_icon_size + 6 ); ?>" height="<?php echo ( $offcanvas_icon_size + 6 ); ?>" fill="<?php echo $offcanvas_color; ?>" class="major_color-lighten-10 bootstrap-list-icon" viewBox="0 0 16 16"><path fill-rule="evenodd" d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5"/></svg>
					<?php } else if ($this->helix3->getParam('offcanvas_icon') == 3 || $this->helix3->getParam('offcanvas_icon') == 4) { ?>
						<?php // Font Awesome and Pixeden icons; ?>
						<i class="<?php echo $offcanvas_icon_class; ?> offcanvas-icon px-1 px-sm-2 px-md-3" aria-hidden="true" title="<?php echo Text::_('HELIX_MENU'); ?>"></i>
					<?php } ?>
				</a>
            </div>
		<?php } 
		
		return ob_get_clean();
	}    
}


